

IF NOT EXISTS (SELECT * FROM SYS.COLUMNS WHERE NAME = 'ID_RECEITA' AND OBJECT_ID = OBJECT_ID('EST_ORC_GLB_MEDICO'))
BEGIN
	ALTER TABLE [EST_ORC_GLB_MEDICO] ADD [ID_RECEITA] INT NOT NULL  DEFAULT( 1 );
END

IF EXISTS (SELECT Col.Column_Name from 
    INFORMATION_SCHEMA.TABLE_CONSTRAINTS Tab, 
    INFORMATION_SCHEMA.CONSTRAINT_COLUMN_USAGE Col 
WHERE 
    Col.Constraint_Name = Tab.Constraint_Name
    AND Col.Table_Name = Tab.Table_Name
    AND Constraint_Type = 'PRIMARY KEY'
    AND Col.Table_Name = 'EST_ORC_GLB_MEDICO')
	
	BEGIN

		ALTER TABLE [dbo].[EST_ORC_GLB_MEDICO] DROP CONSTRAINT [PK_EST_ORC_GLB_MEDICO];
		
		ALTER TABLE [dbo].[EST_ORC_GLB_MEDICO] ADD  CONSTRAINT [PK_EST_ORC_GLB_MEDICO] PRIMARY KEY CLUSTERED 
		(
			[CD_EMP] ASC,
			[CD_FILIAL] ASC,
			[NR_ORC] ASC,
			[CD_IT] ASC,
			[DT_CAD] ASC,
			[ID_RECEITA] ASC
		)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]

	END